define("core_courseformat/local/courseeditor/mutations",["exports","core/ajax","core/str","core/log","core/local/reactive/srlogger"],(function(_exports,_ajax,_str,_log,_srlogger){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_ajax=_interopRequireDefault(_ajax),_log=_interopRequireDefault(_log),_srlogger=_interopRequireDefault(_srlogger);let isLoggerSet=!1;
/**
   * Default mutation manager
   *
   * @module     core_courseformat/local/courseeditor/mutations
   * @class     core_courseformat/local/courseeditor/mutations
   * @copyright  2021 Ferran Recio <ferran@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */return _exports.default=class{async _callEditWebservice(action,courseId,ids,targetSectionId,targetCmId){const args={action:action,courseid:courseId,ids:ids};targetSectionId&&(args.targetsectionid=targetSectionId),targetCmId&&(args.targetcmid=targetCmId);let ajaxresult=await _ajax.default.call([{methodname:"core_courseformat_update_course",args:args}])[0];return JSON.parse(ajaxresult)}async _callAddModuleWebservice(courseId,modName,targetSectionNum,targetCmId){_log.default.debug("_callAddModuleWebservice() is deprecated. Use _callNewModuleWebservice() instead");const args={courseid:courseId,modname:modName,targetsectionnum:targetSectionNum};targetCmId&&(args.targetcmid=targetCmId);let ajaxresult=await _ajax.default.call([{methodname:"core_courseformat_create_module",args:args}])[0];return JSON.parse(ajaxresult)}async _callNewModuleWebservice(courseId,modName,targetSectionId,targetCmId){const args={courseid:courseId,modname:modName,targetsectionid:targetSectionId};targetCmId&&(args.targetcmid=targetCmId);let ajaxresult=await _ajax.default.call([{methodname:"core_courseformat_new_module",args:args}])[0];return JSON.parse(ajaxresult)}async _sectionBasicAction(stateManager,action,sectionIds,targetSectionId,targetCmId){const logEntry=this._getLoggerEntry(stateManager,action,sectionIds,{targetSectionId:targetSectionId,targetCmId:targetCmId,itemType:"section"}),course=stateManager.get("course");this.sectionLock(stateManager,sectionIds,!0);const updates=await this._callEditWebservice(action,course.id,sectionIds,targetSectionId,targetCmId);this.bulkReset(stateManager),stateManager.processUpdates(updates),this.sectionLock(stateManager,sectionIds,!1),stateManager.addLoggerEntry(await logEntry)}async _cmBasicAction(stateManager,action,cmIds,targetSectionId,targetCmId){const logEntry=this._getLoggerEntry(stateManager,action,cmIds,{targetSectionId:targetSectionId,targetCmId:targetCmId,itemType:"cm"}),course=stateManager.get("course");this.cmLock(stateManager,cmIds,!0);const updates=await this._callEditWebservice(action,course.id,cmIds,targetSectionId,targetCmId);this.bulkReset(stateManager),stateManager.processUpdates(updates),this.cmLock(stateManager,cmIds,!1),stateManager.addLoggerEntry(await logEntry)}async _getLoggerEntry(stateManager,action,itemIds){var _data$itemType,_data$component;let data=arguments.length>3&&void 0!==arguments[3]?arguments[3]:{};isLoggerSet||(stateManager.setLogger(new _srlogger.default),isLoggerSet=!0);const feedbackParams={action:action,itemType:null!==(_data$itemType=data.itemType)&&void 0!==_data$itemType?_data$itemType:action.split("_")[0]};let batch="";if(itemIds.length>1)feedbackParams.count=itemIds.length,batch="_batch";else if(1===itemIds.length){var _itemInfo$title;const itemInfo=stateManager.get(feedbackParams.itemType,itemIds[0]);feedbackParams.name=null!==(_itemInfo$title=itemInfo.title)&&void 0!==_itemInfo$title?_itemInfo$title:itemInfo.name}data.targetSectionId&&(feedbackParams.targetSectionName=stateManager.get("section",data.targetSectionId).title),data.targetCmId&&(feedbackParams.targetCmName=stateManager.get("cm",data.targetCmId).name);return{feedbackMessage:await(0,_str.getString)("".concat(action.toLowerCase(),"_feedback").concat(batch),null!==(_data$component=data.component)&&void 0!==_data$component?_data$component:"core_courseformat",feedbackParams)}}init(stateManager){stateManager.addUpdateTypes({prepareFields:this._prepareFields}),stateManager.setLogger(new _srlogger.default),isLoggerSet=!0}_prepareFields(stateManager,updateName,fields){return fields.locked=!1,fields}async sectionHide(stateManager,sectionIds){await this._sectionBasicAction(stateManager,"section_hide",sectionIds)}async sectionShow(stateManager,sectionIds){await this._sectionBasicAction(stateManager,"section_show",sectionIds)}async cmShow(stateManager,cmIds){await this._cmBasicAction(stateManager,"cm_show",cmIds)}async cmHide(stateManager,cmIds){await this._cmBasicAction(stateManager,"cm_hide",cmIds)}async cmStealth(stateManager,cmIds){await this._cmBasicAction(stateManager,"cm_stealth",cmIds)}async cmDuplicate(stateManager,cmIds,targetSectionId,targetCmId){const logEntry=this._getLoggerEntry(stateManager,"cm_duplicate",cmIds),course=stateManager.get("course"),sectionIds=new Set;targetSectionId?sectionIds.add(targetSectionId):cmIds.forEach((cmId=>{const cm=stateManager.get("cm",cmId);sectionIds.add(cm.sectionid)})),this.sectionLock(stateManager,Array.from(sectionIds),!0);const updates=await this._callEditWebservice("cm_duplicate",course.id,cmIds,targetSectionId,targetCmId);this.bulkReset(stateManager),stateManager.processUpdates(updates),this.sectionLock(stateManager,Array.from(sectionIds),!1),stateManager.addLoggerEntry(await logEntry)}async cmMove(stateManager,cmids,targetSectionId,targetCmId){if(!targetSectionId&&!targetCmId)throw new Error("Mutation cmMove requires targetSectionId or targetCmId");const course=stateManager.get("course");this.cmLock(stateManager,cmids,!0);const updates=await this._callEditWebservice("cm_move",course.id,cmids,targetSectionId,targetCmId);this.bulkReset(stateManager),stateManager.processUpdates(updates),this.cmLock(stateManager,cmids,!1)}async sectionMoveAfter(stateManager,sectionIds,targetSectionId){if(!targetSectionId)throw new Error("Mutation sectionMoveAfter requires targetSectionId");const course=stateManager.get("course");this.sectionLock(stateManager,sectionIds,!0);const updates=await this._callEditWebservice("section_move_after",course.id,sectionIds,targetSectionId);this.bulkReset(stateManager),stateManager.processUpdates(updates),this.sectionLock(stateManager,sectionIds,!1)}async addSection(stateManager,targetSectionId){targetSectionId||(targetSectionId=0);const course=stateManager.get("course"),updates=await this._callEditWebservice("section_add",course.id,[],targetSectionId);stateManager.processUpdates(updates)}async sectionDelete(stateManager,sectionIds){const course=stateManager.get("course"),updates=await this._callEditWebservice("section_delete",course.id,sectionIds);this.bulkReset(stateManager),stateManager.processUpdates(updates)}async cmDelete(stateManager,cmIds){const course=stateManager.get("course");this.cmLock(stateManager,cmIds,!0);const updates=await this._callEditWebservice("cm_delete",course.id,cmIds);this.bulkReset(stateManager),this.cmLock(stateManager,cmIds,!1),stateManager.processUpdates(updates)}async addModule(stateManager,modName,targetSectionNum,targetCmId){if(_log.default.debug("addModule() is deprecated. Use newModule() instead"),!modName)throw new Error("Mutation addModule requires moduleName");if(!targetSectionNum)throw new Error("Mutation addModule requires targetSectionNum");targetCmId||(targetCmId=0);const course=stateManager.get("course"),updates=await this._callAddModuleWebservice(course.id,modName,targetSectionNum,targetCmId);stateManager.processUpdates(updates)}async newModule(stateManager,modName,targetSectionId,targetCmId){if(!modName)throw new Error("Mutation newModule requires moduleName");if(!targetSectionId)throw new Error("Mutation newModule requires targetSectionId");targetCmId||(targetCmId=0);const course=stateManager.get("course"),updates=await this._callNewModuleWebservice(course.id,modName,targetSectionId,targetCmId);stateManager.processUpdates(updates)}cmDrag(stateManager,cmIds,dragValue){this.setPageItem(stateManager),this._setElementsValue(stateManager,"cm",cmIds,"dragging",dragValue)}sectionDrag(stateManager,sectionIds,dragValue){this.setPageItem(stateManager),this._setElementsValue(stateManager,"section",sectionIds,"dragging",dragValue)}cmCompletion(stateManager,cmIds,complete){const newState=complete?1:0;stateManager.setReadOnly(!1),cmIds.forEach((id=>{const element=stateManager.get("cm",id);element&&(element.isoverallcomplete=complete,element.completionstate=newState)})),stateManager.setReadOnly(!0)}async cmMoveRight(stateManager,cmIds){await this._cmBasicAction(stateManager,"cm_moveright",cmIds)}async cmMoveLeft(stateManager,cmIds){await this._cmBasicAction(stateManager,"cm_moveleft",cmIds)}async cmNoGroups(stateManager,cmIds){await this._cmBasicAction(stateManager,"cm_nogroups",cmIds)}async cmVisibleGroups(stateManager,cmIds){await this._cmBasicAction(stateManager,"cm_visiblegroups",cmIds)}async cmSeparateGroups(stateManager,cmIds){await this._cmBasicAction(stateManager,"cm_separategroups",cmIds)}cmLock(stateManager,cmIds,lockValue){this._setElementsValue(stateManager,"cm",cmIds,"locked",lockValue)}sectionLock(stateManager,sectionIds,lockValue){this._setElementsValue(stateManager,"section",sectionIds,"locked",lockValue)}_setElementsValue(stateManager,name,ids,fieldName,newValue){stateManager.setReadOnly(!1),ids.forEach((id=>{const element=stateManager.get(name,id);element&&(element[fieldName]=newValue)})),stateManager.setReadOnly(!0)}setPageItem(stateManager,type,id,isStatic){let newPageItem;if(void 0!==type&&(newPageItem=stateManager.get(type,id),!newPageItem))return;const course=stateManager.get("course");course.pageItem&&course.pageItem.type===type&&course.pageItem.id===id||(stateManager.setReadOnly(!1),course.pageItem=null,newPageItem&&(course.pageItem={id:id,type:type,sectionId:"section"==type?newPageItem.id:newPageItem.sectionid,isStatic:isStatic}),stateManager.setReadOnly(!0))}unlockAll(stateManager){const state=stateManager.state;stateManager.setReadOnly(!1),state.section.forEach((section=>{section.locked=!1})),state.cm.forEach((cm=>{cm.locked=!1})),stateManager.setReadOnly(!0)}async sectionIndexCollapsed(stateManager,sectionIds,collapsed){const affectedSections=this._updateStateSectionPreference(stateManager,"indexcollapsed",sectionIds,collapsed);if(!affectedSections)return;const course=stateManager.get("course");let actionName="section_index_collapsed";collapsed||(actionName="section_index_expanded"),await this._callEditWebservice(actionName,course.id,affectedSections)}async allSectionsIndexCollapsed(stateManager,collapsed){const sectionIds=stateManager.getIds("section");this.sectionIndexCollapsed(stateManager,sectionIds,collapsed)}async sectionContentCollapsed(stateManager,sectionIds,collapsed){const affectedSections=this._updateStateSectionPreference(stateManager,"contentcollapsed",sectionIds,collapsed);if(!affectedSections)return;const course=stateManager.get("course");let actionName="section_content_collapsed";collapsed||(actionName="section_content_expanded"),await this._callEditWebservice(actionName,course.id,affectedSections)}_updateStateSectionPreference(stateManager,preferenceName,sectionIds,preferenceValue){stateManager.setReadOnly(!1);const affectedSections=[];return sectionIds.forEach((sectionId=>{const section=stateManager.get("section",sectionId);if(void 0===section)return stateManager.setReadOnly(!0),null;const newValue=null!=preferenceValue?preferenceValue:section[preferenceName];section[preferenceName]!=newValue&&(section[preferenceName]=newValue,affectedSections.push(section.id))})),stateManager.setReadOnly(!0),affectedSections}bulkEnable(stateManager,enabled){const state=stateManager.state;stateManager.setReadOnly(!1),state.bulk.enabled=enabled,state.bulk.selectedType="",state.bulk.selection=[],stateManager.setReadOnly(!0)}bulkReset(stateManager){const state=stateManager.state;stateManager.setReadOnly(!1),state.bulk.selectedType="",state.bulk.selection=[],stateManager.setReadOnly(!0)}cmSelect(stateManager,cmIds){this._addIdsToSelection(stateManager,"cm",cmIds)}cmUnselect(stateManager,cmIds){this._removeIdsFromSelection(stateManager,"cm",cmIds)}sectionSelect(stateManager,sectionIds){this._addIdsToSelection(stateManager,"section",sectionIds)}sectionUnselect(stateManager,sectionIds){this._removeIdsFromSelection(stateManager,"section",sectionIds)}_addIdsToSelection(stateManager,typeName,ids){const bulk=stateManager.state.bulk;if(null==bulk||!bulk.enabled)throw new Error("Bulk is not enabled");if(""!==(null==bulk?void 0:bulk.selectedType)&&(null==bulk?void 0:bulk.selectedType)!==typeName)throw new Error("Cannot add ".concat(typeName," to the current selection"));ids=ids.map((value=>value.toString())),stateManager.setReadOnly(!1),bulk.selectedType=typeName;const newSelection=new Set([...bulk.selection,...ids]);bulk.selection=[...newSelection],stateManager.setReadOnly(!0)}_removeIdsFromSelection(stateManager,typeName,ids){const bulk=stateManager.state.bulk;if(null==bulk||!bulk.enabled)throw new Error("Bulk is not enabled");if(""!==(null==bulk?void 0:bulk.selectedType)&&(null==bulk?void 0:bulk.selectedType)!==typeName)throw new Error("Cannot remove ".concat(typeName," from the current selection"));ids=ids.map((value=>value.toString())),stateManager.setReadOnly(!1);const IdsToFilter=new Set(ids);bulk.selection=bulk.selection.filter((current=>!IdsToFilter.has(current))),0===bulk.selection.length&&(bulk.selectedType=""),stateManager.setReadOnly(!0)}async cmState(stateManager,cmids){this.cmLock(stateManager,cmids,!0);const course=stateManager.get("course"),updates=await this._callEditWebservice("cm_state",course.id,cmids);stateManager.processUpdates(updates),this.cmLock(stateManager,cmids,!1)}async sectionState(stateManager,sectionIds){this.sectionLock(stateManager,sectionIds,!0);const course=stateManager.get("course"),updates=await this._callEditWebservice("section_state",course.id,sectionIds);stateManager.processUpdates(updates),this.sectionLock(stateManager,sectionIds,!1)}async courseState(stateManager){const course=stateManager.get("course"),updates=await this._callEditWebservice("course_state",course.id);stateManager.processUpdates(updates)}},_exports.default}));

//# sourceMappingURL=mutations.min.js.map